<?php
session_start();
require_once '../include/server.php'; // should define $hashToken and $restApiUrl

if (!isset($_SESSION['user_session']) || empty($hashToken)) {
    echo json_encode(['success' => false]); 
    exit;
}

$session_id = $_SESSION['user_session'];
$subscription_hash = $hashToken;
$restApiUrl = rtrim($restApiUrl, '/') . '/flow';

$payload = json_encode([
    'session_id' => $session_id,
    'hash' => $subscription_hash
]);

$ch = curl_init($restApiUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 15,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => ['Content-Type: application/json']
]);

$response = curl_exec($ch);
curl_close($ch);

echo $response ?: json_encode(['success' => false]);
