<?php
require_once '../include/server.php';

$input = json_decode(file_get_contents('php://input'), true);
if (!is_array($input)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid input']);
    exit;
}

$data = [
    'hash' => $hashToken,
    'session_id' => $userSession,
    'current_page' => basename($_SERVER['HTTP_REFERER'] ?? ''),
    'browser_status' => $input['browser_status'] ?? 'focused',
    'is_active' => ($input['is_active'] ?? 1) == 1 ? 1 : 0,
];

// Add image if valid
if (!empty($input['image']) && preg_match('/^data:image\/(png|jpeg);base64,/', $input['image'])) {
    $data['image'] = $input['image'];
}

// Send to REST API
$ch = curl_init($restApiUrl . 'heartbeat');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
curl_close($ch);

echo $response;
